<?php

$baseURL = "";
$Bearer_Token = "";

function getSiteData($shop){
  include '/home/marketappz/public_html/bokashi-shipping/dbConn.php';


  global $Bearer_Token;
  global $baseURL;

  $site_data = mysqli_query($db,"SELECT * FROM shopify_credentials WHERE `shopify_shop` = '$shop'");
  $site_data_row = mysqli_fetch_array($site_data);

  $baseURL = "https://".$site_data_row['shopify_shop'];
  $Bearer_Token = $site_data_row['access_token'];
}

function ShopifyNoQueryGET($GET_URL,$shop,$maxPages = null){
  getSiteData($shop);
  global $Bearer_Token;
  global $baseURL;
  $GET_Token = $Bearer_Token;

  $GET_URL = $baseURL.$GET_URL;

  $curlData = curl_init();
  curl_setopt_array($curlData, array(
    CURLOPT_URL => "$GET_URL",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HEADER => 1,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => array(
      "X-Shopify-Access-Token: ".$GET_Token,
      "content-type: application/json"
    ),
  ));
  $responseData = curl_exec($curlData);

  $header_size = curl_getinfo($curlData, CURLINFO_HEADER_SIZE);
  $body = substr($responseData, $header_size);
  $headers = get_headers_from_curl_responseNoQuery($responseData);

  $err = curl_error($curlData);
  curl_close($curlData);
  if ($err) {
    return "Error";
  } else {

      if (array_key_exists("Link", $headers)) {
        $mainReturn = $body;
        $mainReturn = json_decode($mainReturn,true);
        $first_key = key($mainReturn);

        $pages = returnHeaderArrayNoQuery($headers['Link']);
        $curURL = $pages['next'];

        for ($i=1; $i < $maxPages; $i++) {
          $curlGetMoreData = curl_init();
          curl_setopt_array($curlGetMoreData, array(
            CURLOPT_URL => $curURL,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 90,
            CURLOPT_HEADER => 1,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
              "X-Shopify-Access-Token: ".$GET_Token,
              "content-type: application/json"
            ),
          ));

          $responseData = curl_exec($curlGetMoreData);
          $header_size = curl_getinfo($curlGetMoreData, CURLINFO_HEADER_SIZE);

          $bodyMore = substr($responseData, $header_size);
          $headers = get_headers_from_curl_responseNoQuery($responseData);
          if (array_key_exists("Link", $headers)) {
            $pagesMore = returnHeaderArrayNoQuery($headers['Link']);
            $curURL = $pagesMore['next'];
          }
          $err = curl_error($curlGetMoreData);
          curl_close($curlGetMoreData);
          $bodyMore = json_decode($bodyMore,true);
          $mainReturn[$first_key] = array_merge($mainReturn[$first_key], $bodyMore[$first_key]);
        }
        return json_encode($mainReturn);

      }else{
        return $body;
      }
  }
}

function ShopifyNoQueryPOST($POST_URL,$Post_Data,$shop){
  $newPOST_URL = $POST_URL;
  $newPost_Data = $Post_Data;
  $newshop = $shop;
  getSiteData($shop);
  global $Bearer_Token;
  global $baseURL;
  $POST_Token = $Bearer_Token;
  $POST_URL = $baseURL.$POST_URL;
  $curlData = curl_init();
  curl_setopt_array($curlData, array(
    CURLOPT_URL => "$POST_URL",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => $Post_Data,
    CURLOPT_HTTPHEADER => array(
      "X-Shopify-Access-Token: ".$POST_Token,
      "content-type: application/json"
    ),
  ));

  //curl_setopt($curlData, CURLOPT_HEADER, 1);
  $responseData = curl_exec($curlData);
  $httpcode = curl_getinfo($curlData, CURLINFO_HTTP_CODE);

  $err = curl_error($curlData);
  curl_close($curlData);
  if ($err) {
    echo "cURL Error #:" . $err;
  } else {
    if ($httpcode == "429") {
      echo $httpcode;
      echo "<br>";
      sleep(1);
      ShopifyNoQueryPOST($newPOST_URL,$newPost_Data,$newshop);
    }else {
      return $responseData;
    }
  }
}

function ShopifyNoQueryPUT($PUT_URL,$PUT_Data,$shop){
  getSiteData($shop);
  global $Bearer_Token;
  global $baseURL;
  $PUT_Token = $Bearer_Token;
  $PUT_URL = $baseURL.$PUT_URL;
  $curlData = curl_init();
  curl_setopt_array($curlData, array(
    CURLOPT_URL => "$PUT_URL",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "PUT",
    CURLOPT_POSTFIELDS => $PUT_Data,
    CURLOPT_HTTPHEADER => array(
      "X-Shopify-Access-Token: ".$PUT_Token,
      "content-type: application/json"
    ),
  ));

  $responseData = curl_exec($curlData);
  $err = curl_error($curlData);
  curl_close($curlData);
  if ($err) {
    echo "cURL Error #:" . $err;
  } else {
    return $responseData;
  }
}

function ShopifyNoQueryDELETE($Delete_URL,$shop){
  getSiteData($shop);
  global $Bearer_Token;
  global $baseURL;
  $Delete_Token = $Bearer_Token;
  $Delete_URL = $baseURL.$Delete_URL;

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => "$Delete_URL",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "DELETE",
  CURLOPT_POSTFIELDS => "",
  CURLOPT_HTTPHEADER => array(
    "X-Shopify-Access-Token: $Delete_Token",
    "Content-Type: application/json"
  ),
));
$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);
if ($err) {
  echo "cURL Error #:" . $err;
} else {
  echo $response;
}
}





// Get Pagination Links
function returnHeaderArrayNoQuery($linkHeader) {
    $cleanArray = [];
    if (strpos($linkHeader, ',') !== false) {
        //Split into two or more elements by comma
        $linkHeaderArr = explode(',', $linkHeader);
    } else {
        //Create array with one element
        $linkHeaderArr[] = $linkHeader;
    }

    foreach ($linkHeaderArr as $linkHeader) {
        $cleanArray += [
            extractRelNoQuery($linkHeader) => extractLinkNoQuery($linkHeader)
        ];
    }
    return $cleanArray;
}

function extractLinkNoQuery($element) {
    if (preg_match('/<(.*?)>/', $element, $match) == 1) {
        return $match[1];
    }
}

function extractRelNoQuery($element) {
    if (preg_match('/rel="(.*?)"/', $element, $match) == 1) {
            return $match[1];
    }
}

function get_headers_from_curl_responseNoQuery($response){
    $headers = array();

    $header_text = substr($response, 0, strpos($response, "\r\n\r\n"));

    foreach (explode("\r\n", $header_text) as $i => $line)
        if ($i === 0)
            $headers['http_code'] = $line;
        else
        {
            list ($key, $value) = explode(': ', $line);

            $headers[$key] = $value;
        }

    return $headers;
}

function ShopifyNoQueryGETStoreNext($GET_URL,$shop,$maxPages = null){
  include '/home/marketappz/public_html/bokashi-shipping/dbConn.php';

  getSiteData($shop);
  global $Bearer_Token;
  global $baseURL;
  $GET_Token = $Bearer_Token;

  //$GET_URL = $baseURL.$GET_URL;

  $curlData = curl_init();
  curl_setopt_array($curlData, array(
    CURLOPT_URL => "$GET_URL",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HEADER => 1,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => array(
      "X-Shopify-Access-Token: ".$GET_Token,
      "content-type: application/json"
    ),
  ));
  $responseData = curl_exec($curlData);

  $header_size = curl_getinfo($curlData, CURLINFO_HEADER_SIZE);
  $body = substr($responseData, $header_size);
  $headers = get_headers_from_curl_responseNoQuery($responseData);

  $err = curl_error($curlData);
  curl_close($curlData);
  if ($err) {
    return "Error";
  } else {
    if (array_key_exists("Link", $headers)) {
      $pages = returnHeaderArrayNoQuery($headers['Link']);
      $curURL = $pages['next'];

      $getNextLink = mysqli_query($db,"SELECT * FROM `order_sync` WHERE `shop`='$shop'");
      if (mysqli_num_rows($getNextLink) > 0) {
        $updateLink = mysqli_query($db,"UPDATE `order_sync` SET `status`='syncing', `next_url`='$curURL' WHERE `shop`='$shop'");
      }else{
        $insertLink = mysqli_query($db,"INSERT INTO `order_sync`(`shop`, `next_url`,`status`) VALUES ('$shop','$curURL','syncing')");
      }

      return $body;
    }else{
      $updateStatus = mysqli_query($db,"UPDATE `order_sync` SET `status`='complete' WHERE `shop`='$shop' AND `next_url` = '$GET_URL'");
      return $body;
    }
  }
}


?>
